//----------------------------------------------------------------------------
// Globals
//----------------------------------------------------------------------------
//

// constants for Buddylist changes ( see TBuddyListChange )
var KBuddyListStatusChanged = 0;
var KBuddyListBuddyAdded    = 1;
var KuddyListBuddyRemoved   = 2;
var KBuddyListRosterReady   = 3;
var KBuddyListRosterSorted  = 4;
var KBuddyListVCardReceived = 5;
var KBuddyListCapsChanged   = 6;
var KBuddyListBuddyIsOnline = 7;

// constants for Pep event types
var KLocationPepEvent      = "http://jabber.org/protocol/geoloc"; // Location
var KMusicPresencePepEvent = "http://jabber.org/protocol/tune";   // Music presence

// currently focused element
var gFocusedElement = "";

//----------------------------------------------------------------------------
// Send element focus command to client
//----------------------------------------------------------------------------
//
function elementFocuced( element )
    {
    gFocusedElement = element.id;
    return prompt( "focus", element.id );
    }

//----------------------------------------------------------------------------
// Send element click command to client
//----------------------------------------------------------------------------
//
function elementClicked( element )
    {
    return prompt( "click", element.id );
    }

//----------------------------------------------------------------------------
// set innerHTML of an element
//----------------------------------------------------------------------------
//
function setInnerHTML( element, content )
    {
    var element = document.getElementById( element );
    element.innerHTML = content;
    }

//----------------------------------------------------------------------------
// Reads a file from local filesystem and notifies callback on completion
//----------------------------------------------------------------------------
function readFileHttp( fname, callback )
    {
    xmlhttp = new XMLHttpRequest();
    xmlhttp.onreadystatechange = function()
        {
        callback(xmlhttp.responseText);
        }
    xmlhttp.open("GET", fname, true);
    xmlhttp.send(null);
    }

//----------------------------------------------------------------------------
// Resolves Precense icon and text for it
//----------------------------------------------------------------------------
//
function get_presenseStateTextAndIcon( presense )
    {
    var map =
        [
        {txt : "xmppPresenceChatText",        img : "qgn_stat_indi_y_chatty.png"},
        {txt : "xmppPresenceAvailableText",   img : "qgn_stat_indi_y_available.png"},
        {txt : "xmppPresenceAwayText",        img : "qgn_stat_indi_y_away.png"},
        {txt : "xmppPresenceXAwayText",       img : "qgn_stat_indi_y_extaway.png"},
        {txt : "xmppPresenceDoNotDisturbText",img : "qgn_stat_indi_y_dnd.png"},
        {txt : "xmppPresencePendingText",     img : "qgn_stat_indi_y_pending.png"},
        {txt : "xmppPresenceOnThePhoneText",  img : "qgn_stat_indi_y_onphone.png"},
        {txt : "xmppPresenceUnavailableText", img : "qgn_stat_indi_y_offline.png"},
        {txt : "xmppPresenceInvisibleText",   img : "qgn_stat_indi_y_invisible.png"},
        {txt : "xmppPresenceUndefinedText",   img : "qgn_stat_indi_y_offline.png"}
        ]

    return map[presense];
    }


//////////////////////////////////////////////////////////////////////////////
//                         UTILITY FUNCTIONS                                //
//////////////////////////////////////////////////////////////////////////////


// ---------------------------------------------------------------------------
// Event type: http://jabber.org/protocol/tune
// Given callback will be called for <item> node of stanza. Callback
// have one argument - object, that describes <item>.
// ---------------------------------------------------------------------------
//
function parsePepTune( stanza, callback ){
    // get unescaped xml
    var xml = stanza.fromUtf8().xmlUnescape();

    var item = new Object;
    item.artist = extractXmlElementData( xml, "artist" );
    item.title  = extractXmlElementData( xml, "title" );
    item.track  = extractXmlElementData( xml, "track" );
    callback( item );
}

// ---------------------------------------------------------------------------
// Event type: http://jabber.org/protocol/geoloc
// Given callback will be called for <item> node of stanza. Callback
// have one argument - object, that describes <item>.
// ---------------------------------------------------------------------------
//
function parsePepGeoloc( stanza, callback ){
    // get unescaped xml
    var xml = stanza.fromUtf8().xmlUnescape();

    var item = new Object;
    item.loctext = extractXmlElementData( xml, "text" );
    callback( item );
}

// ---------------------------------------------------------------------------
// Extends String.prototype with method for trimming string
// ---------------------------------------------------------------------------
//
String.prototype.trim = function()
    {
    return this.replace(/^\s+|\s+$/g,"");
    }

// ---------------------------------------------------------------------------
// Extends String.prototype with method for removing LFs and CRs from
// the string
// ---------------------------------------------------------------------------
//
String.prototype.removeLFsAndCRs = function() {    
    var returnedStr = "";
    var i = 0;
    var ch = 0;
    
    while ( i < this.length )
        {
        if ( ( 13 != this.charCodeAt( i ) ) && // CR
             ( 10 != this.charCodeAt( i ) ) )  // LF   
            {
            returnedStr += String.fromCharCode( this.charCodeAt( i ) ); 
            }
        i++;
        }
    return returnedStr;
    }   

// ---------------------------------------------------------------------------
// Extends String.prototype with method for decode UTF-8 text
// ---------------------------------------------------------------------------
//
String.prototype.fromUtf8 = function() {
    var str="";
    var i=0;
    var ch = ch2 = 0;

    while ( i < this.length ) {
        ch = this.charCodeAt(i);
        if (ch < 128) {
            str += String.fromCharCode(ch);
            i++;
            }
        else if((ch > 191) && (ch < 224)) {
            ch2 = this.charCodeAt(i+1);
            str += String.fromCharCode(((ch & 31) << 6) | (ch2 & 63));
            i += 2;
            }
        else {
            ch2 = this.charCodeAt(i+1);
            var ch3 = this.charCodeAt(i+2);
            str += String.fromCharCode(((ch & 15) << 12) | ((ch2 & 63) << 6) | (ch3 & 63));
            i += 3;
            }
        }
    return str;
    }

// ---------------------------------------------------------------------------
// Extends String.prototype with method for unescape xml
// ---------------------------------------------------------------------------
//
String.prototype.xmlUnescape = function()
    {
    return this.replace(/&lt;/g, "<")
        .replace(/&gt;/g, ">")
        .replace(/&quot;/g,"\"")
        .replace(/&amp;/g, "&")
        .replace(/&apos;/g,"'");
    }

// ---------------------------------------------------------------------------
// Extract element data from xml data
// ---------------------------------------------------------------------------
//
function extractXmlElementData( xmlData, elementName )
    {
    startTag = "<" + elementName + ">";
    endTag = "</" + elementName + ">";
    value = "";

    start = xmlData.search( startTag );
    end = xmlData.search( endTag );

    if ( ( -1 != start ) && ( -1 != end ) && ( end > start )  )
        {
        value = xmlData.substring( start + startTag.length, end );
        }

    return value;
    }
