//----------------------------------------------------------------------------
// Globals
//----------------------------------------------------------------------------
//

// current page width. Needed in layout setting.
var gCurrentWidth = 0;

// Connection state
var gConnectionSate = 0; // 0 == Offline

// Xmpp server interface
var gXmppPlugin;

// Buddylist interface
var gBuddyList;

// Jid of user shown in the view
var gJid = "";

//----------------------------------------------------------------------------
// Handle requests from client-side
//----------------------------------------------------------------------------
//
function onClientRequest( keyEvent )
    {
    keyEvent  = keyEvent ? keyEvent : window.event;
    var event = keyEvent.keyCode ? keyEvent.keyCode : keyEvent.which;

    switch ( event )
        {
        // update layout
        case 1:
            {
            // not used
            }
            break;

        // scroll to top
        case 2:
            {
            window.scrollTo( 0, 0 );
            }
            break;

        // activity event
        case 28:
            {
            readFileHttp( "c:\\private\\2001a928\\form_data.txt", setActivity );
            }
            break;
        }
    }

//----------------------------------------------------------------------------
// Initialize form
//----------------------------------------------------------------------------
//
function initForm()
    {
    // Get Xmpp server interface
    try {
         gXmppPlugin = document.getElementById("nokiaXmppPlugin");
        }
    catch( error )
        {
        }

    if ( gXmppPlugin )
        {
        // set call back for connection state changes
        gXmppPlugin.onChangeState = connectionStateChanged;

        // Get Buddylist IF
        gBuddyList = gXmppPlugin.BuddyList;

        // save JID
        gJid = document.getElementById( "title_jid" ).innerHTML;

        // set callback about buddylist changes
        gBuddyList.onChange = buddyListChanged;

        // set callback about PEP events
        gXmppPlugin.Pep.onEvent = pepEventReceived;
        gXmppPlugin.Pep.subscribe( "http://jabber.org/protocol/geoloc" );
        gXmppPlugin.Pep.subscribe( "http://jabber.org/protocol/tune" );
        }
    updateLayout();
    }

//----------------------------------------------------------------------------
// Check page layout and tune header style
//----------------------------------------------------------------------------
//
function updateLayout()
    {
    var windowWidth = window.innerWidth;
    var headerElement = document.getElementById( 'header' );
    headerElement.style.width = windowWidth;
    var contentElement = document.getElementById( 'content' );
    contentElement.style.width = windowWidth;
    }

//----------------------------------------------------------------------------
// Callback about connection state change
//----------------------------------------------------------------------------
//
function connectionStateChanged( state )
    {
    // save new connection state
    gConnectionSate = state;
    setStatusOffline();	
    }
	
//----------------------------------------------------------------------------
// Set status offline after logging out
//----------------------------------------------------------------------------
//
function setStatusOffline()
    {
    if ( gConnectionSate  == 0 )
        {
        if ( gJid )
            {
            var buddy = gXmppPlugin.getBuddy( gJid );
            // Get icon and text according to presence state
            var textAndIcon = get_presenseStateTextAndIcon( buddy.presenceStatus );				
            // Set icon
            document.getElementById( "title_status_img" ).src = textAndIcon.img;
            // set text
            document.getElementById( "title_presence" ).innerHTML = document.getElementById( textAndIcon.txt ).value;
            }
        }
    }

//----------------------------------------------------------------------------
// Callback about changes in buddy list
//----------------------------------------------------------------------------
//
function buddyListChanged( jid, change )
    {
    // Check if the change happened in the profile that is
    // visible at the moment in this view
    if ( gJid == jid )
        {
        // check what was changed and update HTML page
        switch( change )
            {
            case KBuddyListBuddyIsOnline:
            case KBuddyListStatusChanged:
                {
                // Get buddy object
                var buddy = gXmppPlugin.getBuddy( gJid );

                // Get icon and text according to presence state
                var textAndIcon = get_presenseStateTextAndIcon( buddy.presenceStatus );

                // Set icon
                document.getElementById( "title_status_img" ).src = textAndIcon.img;

                // set text
                document.getElementById( "title_presence" ).innerHTML = document.getElementById( textAndIcon.txt ).value;

                // set status text
                if ( buddy.detailedStatus )
                    {
                    // set text
                    setTimeout( "setInnerHTML( 'title_status_span', '"+ buddy.detailedStatus.fromUtf8()  +"' )", 10 );
                    }
                else
                    {
                    // remove text
                    setTimeout( "setInnerHTML( 'title_status_span', '"+""+"' )", 10 );
                    }
                break;
                }
            case KBuddyListCapsChanged:
            case KBuddyListBuddyAdded:
            case KuddyListBuddyRemoved:
            case KBuddyListRosterReady:
            case KBuddyListRosterSorted:
                {
                // do nothing
                break;
                }
            case KBuddyListVCardReceived:
                {
                if ( 1 >= gXmppPlugin.getVcard( gJid ).avatar.length )
                    {
                    // no avatar set the default one
                    setDefaultAvatar();
                    }
                else
                    {
                    // avatar included take it into use
                    var newAvatar = "data:" + gXmppPlugin.getVcard( gJid ).avatarType + ";base64," + gXmppPlugin.getVcard( gJid ).avatar;
                    var avatarImg = document.getElementById( "title_avatar_img" );
                    if ( avatarImg )
                        {
                        avatarImg.src = newAvatar;
                        }
                    }
                break;
                }
            }
        }
    }

//----------------------------------------------------------------------------
// Callback about PEP events
//----------------------------------------------------------------------------
//
function pepEventReceived( jid, eventType, content )
    {
    // Check if the change happened in the profile that is
    // visible at the moment in this view
    if ( gJid == jid )
        {
        switch( eventType )
            {
            case KLocationPepEvent:
                {
                // Add dummy element around received data, needed in parsing
                var modifiedContent = "<location>" + content + "</location>";

                // Get location from event data and set it to html
                parsePepGeoloc( modifiedContent, locationParsingDone );

                break;
                }
            case KMusicPresencePepEvent:
                {
                // Add dummy element around received data, needed in parsing
                var modifiedContent = "<music>" + content + "</music>";

                // Get music pres. from event data and set it to html
                parsePepTune( modifiedContent, musicPresenceParsingDone );

                break;
                }
            }
        }
    }

//----------------------------------------------------------------------------
// Callback about completed music presence parsing
//----------------------------------------------------------------------------
//
function musicPresenceParsingDone( item )
    {
    var musicPresence = "";

    // Create string

    // Artist
    if ( "" != item.artist )
        {
        musicPresence += item.artist;
        }

    // Track
    if ( "" != item.track )
        {
        if ( "" != item.artist )
            {
            musicPresence += "-"
            }
        musicPresence += item.track ;
        }

    // Title
    if ( "" != item.title )
        {
        if ( ( "" != item.track  )  || ( "" == item.track && "" != item.artist ) )
            {
            musicPresence += "-"
            }
        musicPresence += item.title ;
        }

    // set item visible/invisible
    if ( "" == musicPresence )
        {
        document.getElementById("nowplaying" ).className = "hidden";

        // Set EMPTY Music pres. to page
        setTimeout( "setInnerHTML( 'nowplaying_a', '"+musicPresence+"' )", 10 );
        }
    else
        {
        document.getElementById("nowplaying" ).className = "visible";

        // Set Music pres to page
        setTimeout( "setInnerHTML( 'nowplaying_a', '"+musicPresence+"' )", 10 );
        }
    }

//----------------------------------------------------------------------------
// Callback about completed location data parsing
//----------------------------------------------------------------------------
//
function locationParsingDone( item )
    {
    // Create location string
    var location = "";

    if ( "" != item.loctext )
        {
        location = item.loctext;
        }

    // set item visible/invisible
    if ( "" == location )
        {
        document.getElementById("currentlocation" ).className = "hidden";

        // Set Location to page
        setTimeout( "setInnerHTML( 'currentlocation_span', '"+location+"' )", 10 );
        }
    else
        {
        document.getElementById("currentlocation").className = "visible";

        // Set Location to page
        setTimeout( "setInnerHTML( 'currentlocation_span', '"+location+"' )", 10 );
        }
    }

//----------------------------------------------------------------------------
// Set default avatar image
//----------------------------------------------------------------------------
//
function setDefaultAvatar()
    {
    var avatarImg = document.getElementById( "title_avatar_img" );
    if ( avatarImg )
        {
        avatarImg.src = "c:/private/2001a928/qgn_prop_y_default_friend.png";
        }
    }

//----------------------------------------------------------------------------
// Set activity by subscribing or unsubscribing from pep events
//----------------------------------------------------------------------------
//
function setActivity( data )
    {
    if ( data )
        {
        if ( "0" == data )
            {
            gXmppPlugin.Pep.onEvent = pepEventReceived;
            gXmppPlugin.Pep.unsubscribe( "http://jabber.org/protocol/geoloc" );
            gXmppPlugin.Pep.unsubscribe( "http://jabber.org/protocol/tune" );
            }
        else
            {
            gXmppPlugin.Pep.onEvent = pepEventReceived;
            gXmppPlugin.Pep.subscribe( "http://jabber.org/protocol/geoloc" );
            gXmppPlugin.Pep.subscribe( "http://jabber.org/protocol/tune" );
            }
        }
    }
