// currently active element
var gBaseActiveElement = null;

//----------------------------------------------------------------------------
// Makes background red. For test purposes only.
//----------------------------------------------------------------------------
//
function red()
    {
    document.body.style.background = "#FF0000 url(none)";
    }

//----------------------------------------------------------------------------
// Send request to client-side and receive response. Return client's response.
//----------------------------------------------------------------------------
//
function doClientRequest( event, param )
    {
    // We use javascript::prompt() on JScript side, and S60 WebKit's
    // MBrCtlDialogsProvide::DialogPromptLC(...) on client side, to pass
    // request's params ( as text ) from browser to client.
    //
    // Set title to "doClientRequest" to be recognized by client.
    var pckg = event + ":" + ( param ? param : "0");
    return prompt( "doClientRequest", pckg );
    }

//----------------------------------------------------------------------------
// Callback handles requests from client-side
//----------------------------------------------------------------------------
//
function onClientRequest( keyEvent )
    {
    keyEvent  = keyEvent ? keyEvent : window.event;
    var event = keyEvent.keyCode ? keyEvent.keyCode : keyEvent.which;

    if ( event == 1 )      // execute JScript statement
        {
        var statement = doClientRequest( 11, "" );
        doClientRequest( 12,  eval( statement ) );
        }
    else if ( event == 2 ) // set inner html
        {
        var elementId    = doClientRequest( 21, "" );
        var elementValue = doClientRequest( 22, "" );
        setInnerHtml( elementId, elementValue );
        }
    else if ( event == 3 ) // get inner html
        {
        var elementId = doClientRequest( 31, "" );
        doClientRequest( 32, getInnerHtml( elementId ) );
        }
    else if ( event == 4 ) // rocker key press
        {
        doClientRequest( 45, gBaseActiveElement );
        }
    }


//----------------------------------------------------------------------------
// Set inner html safely
//----------------------------------------------------------------------------
//
function setInnerHtml( elementId, innerHtml )
    {
    if ( document.getElementById( elementId ) )
        {
        document.getElementById( elementId ).innerHTML = innerHtml;
        }
    }

//----------------------------------------------------------------------------
// Get inner html safely
//----------------------------------------------------------------------------
//
function getInnerHtml( elementId )
    {
    if ( document.getElementById( elementId ) )
        {
        return document.getElementById( elementId ).innerHTML;
        }
    return "";
    }

//----------------------------------------------------------------------------
// Make page visible 
//----------------------------------------------------------------------------
//
function makePageVisible()
    {
    document.body.style.display = 'block';
    }

//----------------------------------------------------------------------------
// Selector should be defined before
//----------------------------------------------------------------------------
//
function setCSSProperty( sSelector, propertyName, propertyValue )
    {
    for ( i = 0; i < document.styleSheets.length; i++)
        {
        if ( !document.styleSheets[i].cssRules )
            continue;

        for( j = 0; j < document.styleSheets[i].cssRules.length; j++ )
            {
            //return document.styleSheets[i].cssRules[j].selectorText;
            if ( document.styleSheets[i].cssRules[j].selectorText.toUpperCase() != sSelector.toUpperCase() )
                continue;
            document.styleSheets[i].cssRules[j].style.setProperty( propertyName,
                propertyValue, null );
            }
        }
    }

//----------------------------------------------------------------------------
// Notify s60 client about 'onmouseover' event
//----------------------------------------------------------------------------
//
function onBaseMouseOver( e )
    {
    gBaseActiveElement = e.id;
    doClientRequest( 41, e.id );
    }

//----------------------------------------------------------------------------
// Notify s60 client about 'onmouseout' event
//----------------------------------------------------------------------------
//
function onBaseMouseOut( e )
    {
    doClientRequest( 42, e.id );
    }

//////////////////////////////////////////////////////////////////////////////

// Id of HtmlElement to apply javascript::blur()
//
var gHtmlElementIdToBlur = ""

//----------------------------------------------------------------------------
// Move focus out from Html element
//----------------------------------------------------------------------------
//
function doBlurElement( elemId )
    {
    gHtmlElementIdToBlur = elemId;

    e = document.getElementById( gHtmlElementIdToBlur );
    if ( e && e.blur )
        {
        e.blur();
        }
    window.setTimeout( doBlurElementImpl, 100 );
    }

//----------------------------------------------------------------------------
// Move focus out from Html element
//----------------------------------------------------------------------------
//
function doBlurElementImpl()
    {
    e = document.getElementById( gHtmlElementIdToBlur );
    if ( e && e.blur )
        {
        e.blur();
        }
    doClientRequest( 73, "gHtmlElementIdToBlur" );
    }

//----------------------------------------------------------------------------
// Ask client to simulate key event
//----------------------------------------------------------------------------
//
function simulateKeyEvent( code  )
    {
    doClientRequest( 51, code );
    }

//----------------------------------------------------------------------------
// Set active element id
//----------------------------------------------------------------------------
//
function setActiveElementId( elementId )
    {
    gBaseActiveElement = elementId;
    }

//----------------------------------------------------------------------------
// Store given DOM node to string
//----------------------------------------------------------------------------
//
function nodeToXML(node, indentation, out)
    {
    out += indentation+"<"+node.nodeName.toLowerCase();
    if (node.attributes!=null) {
        for ( var i=0; i<node.attributes.length; i++ )
            {
            var item = node.attributes.item(i);
            var value = item.nodeValue;
            if (value==null) value = "";
            out += " "+item.nodeName+"=\""+value+"\"";
            }
        }

    out += ">\n";
    for ( var i=0; i<node.childNodes.length; i++ )
        {
        var item = node.childNodes.item(i);
        out = nodeToXML(item, indentation+"   ", out);
        }
    if ( node.nodeValue!=null )
        {
        out += indentation+"   "+node.nodeValue+"\n";
        }
    out += indentation+"</"+node.nodeName.toLowerCase()+">\n";
    return out;
    }
