/*jslint white: true, devel: false, onevar: true, browser: true, undef: true,
  nomen: true, regexp: true, plusplus: true, bitwise: true, newcap: true,
  maxerr: 50, indent: 4 */
/*global window: false, console: false,
  headertext: false, headericon: false, contenttext: false,
  button1text: false, button1image: false, button1link: false,
  button2text: false, button2image: false, button2link: false
  button3text: false, button3image: false, button3link: false*/

var tipview = {};
tipview.assetPath = '../../COMMON/CSS/ICONS/';

tipview.refresh = function () {
    var orientation = window.innerHeight > window.innerWidth ? 'portrait' : 'landscape';
    document.getElementById('container').className = orientation;
};

window.onload = function () {
    var titleIcon, texts, i, text, image, link, button, btext, bimage, bbottom;
    tipview.refresh();

    // header
    document.getElementsByTagName('h1')[0].innerHTML = headertext;
    titleIcon = document.createElement('img');
    titleIcon.src = tipview.assetPath + headericon;
    document.getElementById('header-top').appendChild(titleIcon);

    // content text
    texts = document.getElementsByTagName('p');
    for (i = 0; i < texts.length; i += 1) {
        if (texts[i].className === 'text') {
            texts[i].innerHTML = contenttext;
        }
    }

    // Add 0-3 buttons depending whether they exist.
    for (i = 1; i < 4; i += 1) {
        text = window['button' + i + 'text'];
        image = window['button' + i + 'image'];
        link = window['button' + i + 'link'];
        if (text && image && link) {
            button = document.createElement('a');
            button.href = link;

            bimage = document.createElement('img');
            bimage.src = tipview.assetPath + image;

            btext = document.createElement('span');
            btext.className = 'button-text';
            btext.innerHTML = text;
            button.appendChild(btext);

            bbottom = document.createElement('span');
            bbottom.className = 'button-bottom';
            button.appendChild(bbottom);

            document.getElementById('button' + i).appendChild(bimage);
            document.getElementById('button' + i).appendChild(button);

        }
    }

};

window.onresize = tipview.refresh;
