var collapsed = true;
var displayImagesHidden = false;

function collapseHeader(sendEvent) {
    if (sendEvent) {
        location.href = "cmail://collapseHeader/";
    }
    collapsed = true;
    handleHeaderDisplay( "header_expanded", "header_collapsed" );
    showTable( "header_collapsed_2" );
    hideTable( "to_table" );
    hideTable( "cc_table" );
    hideTable( "bcc_table" );
    hideTable( "header_expanded_2" );
    handleHeaderDisplay( "to_expanded", "to_collapsed" );
    handleHeaderDisplay( "cc_expanded", "cc_collapsed" );
    handleHeaderDisplay( "bcc_expanded", "bcc_collapsed" );
    if (sendEvent) {
        handleHeaderDisplay( "attachments_expanded", "attachments_collapsed" );
    }
    updateHeader();
}

function initHeader() {

    if (typeof(is_header_expanded_visible) !== "undefined" && !is_header_expanded_visible) {
        handleHeaderDisplay( "header_expanded", "header_collapsed" );
        collapsed = true;
    }

    if (typeof(is_header_collapsed_visible) !== "undefined" && !is_header_collapsed_visible) {
        hideTable( "header_collapsed" );
        collapsed = false;
    }

    if (typeof(is_header_collapsed_2_visible) !== "undefined" && !is_header_collapsed_2_visible) {
        hideTable( "header_collapsed_2" );
    }

    if (typeof(is_header_expanded_2_visible) !== "undefined" && !is_header_expanded_2_visible) {
        hideTable( "header_expanded_2" );
    }

    if (typeof(is_to_table_visible) !== "undefined") {
        if (!is_to_table_visible) {
            hideTable( "to_table" );
            handleHeaderDisplay( "to_expanded", "to_collapsed" );
        } else {
            if (typeof(is_to_expanded_visible) !== "undefined" ) {
                if (is_to_expanded_visible) {
                    handleHeaderDisplay( "to_collapsed", "to_expanded" );
                } else {
                    handleHeaderDisplay( "to_expanded", "to_collapsed" );
                }
            } else {
                handleHeaderDisplay( "to_expanded", "to_collapsed" );
            }
        }
    }

    if (typeof(is_cc_table_visible) !== "undefined") {
        if (!is_cc_table_visible) {
            hideTable( "cc_table" );
            handleHeaderDisplay( "cc_expanded", "cc_collapsed" );
        } else {
            if (typeof(is_cc_expanded_visible) !== "undefined" && is_cc_expanded_visible) {
                handleHeaderDisplay( "cc_collapsed", "cc_expanded" );
            } else {
                handleHeaderDisplay( "cc_expanded", "cc_collapsed" );
            }
        }
    }

    if (typeof(is_bcc_table_visible) !== "undefined") {
        if (!is_bcc_table_visible) {
            hideTable( "bcc_table" );
            handleHeaderDisplay( "bcc_expanded", "bcc_collapsed" );
        } else {
        if (typeof(is_bcc_expanded_visible) !== "undefined" && is_bcc_expanded_visible) {
                handleHeaderDisplay( "bcc_collapsed", "bcc_expanded" );
            } else {
                handleHeaderDisplay( "bcc_expanded", "bcc_collapsed" );
            }
        }
    }

    if (typeof(is_header_expanded_2_visible) !== "undefined" && !is_header_expanded_2_visible) {
        hideTable( "attachments_expanded" );
    }

    if (typeof(is_attachments_expanded_visible) !== "undefined" && is_attachments_expanded_visible) {
        handleHeaderDisplay( "attachments_collapsed" , "attachments_expanded" );
    } else {
        handleHeaderDisplay( "attachments_expanded", "attachments_collapsed" );
    }

    hideDisplayImagesButton();
}

function expandHeader(sendEvent) {
    if (sendEvent) {
        location.href = "cmail://expandHeader/";
    }
    collapsed = false;
    handleHeaderDisplay( "header_collapsed", "header_expanded" )
    hideTable( "header_collapsed_2" );
    showTable( "to_table" );
    showTable( "cc_table" );
    showTable( "bcc_table" );
    showTable( "header_expanded_2" );
    updateHeader();
}

function updateHeader() {
    var rows = "30%, *";
    if (collapsed) {
        if (displayImagesHidden || (parent.header_frame.g_autoLoadImages != 0) || (parent.hiddenCount == 0)) {
            rows = "10%, *";
        } else {
            rows = "19%, *";
        }
    }
    parent.document.getElementById('email_frameSet').rows = rows;
}

function showTable( tableToShow ) {
    var table = document.getElementById( tableToShow );
    if ( table != null ) {
        table.style.display = "";
    }
}

function hideTable( tableToHide ) {
    var table = document.getElementById( tableToHide );
    if ( table != null ) {
        table.style.display = "none";
    }
}

function handleHeaderDisplay( tableToHide, tableToShow ) {
    showTable(tableToShow);
    if (document.getElementById(tableToShow) != null) {
        hideTable(tableToHide);
    } else {
        showTable(tableToHide);
    }
}

function init( scrollPos ) {
    initHeader();
    // in vga resolution we need to increase the header font size
    // the default font size defined in header.css can  be used for other resolutions
    // same font sizes are used for body font size also (see email.js)
    if (screen.width == 640 && screen.height == 480) {
        var tdlist = document.getElementsByTagName("td");
        for (var i = 0; i < tdlist.length; i++) {
            tdlist[i].style.fontSize = "26px";
        }
    }
    parent.window.scroll( 0, scrollPos );
    setTimeout( "updateScrollPosition()", 300 );
}

function displayImagesButtonPressed() {
    hideDisplayImagesButton();
    parent.restoreImages( "body_frame" );
    requestDisplayImages();
}

function hideDisplayImagesButton() {
    hideTable( "displayImagesTable" );
    displayImagesHidden = true;
    updateHeader();
}

function showDisplayImagesButton() {
    showTable( "displayImagesTable" );
    displayImagesHidden = false;
    updateHeader();
}

function requestDisplayImages() {
    location.href = "cmail://displayImages/";
}

function updateScrollPosition() {
    location.href = "cmail://body/" + parent.pageYOffset;
}

function handleResize() {
    width = window.screen.width - 10;
    setElementWidth( "header_collapsed", width );
    setElementWidth( "header_collapsed_2", width );
    setElementWidth( "header_expanded", width );
    setElementWidth( "to_table", width );
    setElementWidth( "cc_table", width );
    setElementWidth( "bcc_table", width );
    setElementWidth( "header_expanded_2", width );
    setElementWidth( "attachments_collapsed", width );
    setElementWidth( "attachments_expanded", width );
    setElementWidth( "displayImagesTable", width );
}

function setElementWidth(elementId, width) {
    element = document.getElementById(elementId);
    if (element != null) {
        element.width = width + "px";
    }
}

/**
* Takes color in rgb( red, green, blue ) format, parses numbers from them and returns an array
* with R G and B color channels.
*/
function rgbSplit(rgb) {
	var re = new RegExp(/\((.*)\)/);
	var temp = re.exec(rgb);
	var arr = temp[1].split(",");
	if(arr.length==3) {
		return{R:parseInt(arr[0]),G:parseInt(arr[1]),B:parseInt(arr[2])};
	}
	else{
		if(arr.length==4) {
			return{R:parseInt(arr[1]),G:parseInt(arr[2]),B:parseInt(arr[3])};
		}
	}
	return{R:0,G:0,B:0};
}


/**
* Emulates opacity by calculating a new color for it based on body background and text color.
* Returns the calculated color
*/
function calculateOpacityColor(opacity) {
	var r = 0, g = 0, b = 0;
    tempColor = document.defaultView.getComputedStyle(document.body, null).getPropertyValue("background-color");
	elemBackgroundColor = rgbSplit(tempColor);
	tempColor2 = document.defaultView.getComputedStyle(document.body, null).getPropertyValue("color");
	elemColor = rgbSplit(tempColor2);
	//formula
	//newcolor = opacity*original + (1-opacity)*background              
	r = parseInt(opacity * elemColor.R + (1 - opacity) * elemBackgroundColor.R);
    g = parseInt(opacity * elemColor.G + (1 - opacity) * elemBackgroundColor.G);
    b = parseInt(opacity * elemColor.B + (1 - opacity) * elemBackgroundColor.B);
    var newColor = "rgb(" + r + ", " + g + ", " + b + ")";
	return newColor;
}

/**
 * Calculates new text color for class elem.
 */
function setTextColorWithOpacity(elem, opacity) {
		var newColor = calculateOpacityColor(opacity);
		changecss(elem, "color", newColor);
}


/**
* Searches stylesheet and changes element value in myclass to value
*/
function changecss(myclass, element, value) {
    var CSSRules
    if (document.all) {
	    CSSRules = 'rules'
    }
    else if (document.getElementById) {
	    CSSRules = 'cssRules'
    }
	//Go through the stylesheet embedded in header.html
	for (var i = 0; i < document.styleSheets[0][CSSRules].length; i++) {
        if (document.styleSheets[0][CSSRules][i].selectorText == myclass) {
			    document.styleSheets[0][CSSRules][i].style[element] = value;
	    }
	}
}

/**
* Creates gradient element and inserts it in the stylesheet in the html header.
*/
function createGradient(targetElement, opacity) {
	bgColor = document.defaultView.getComputedStyle(document.body, null).getPropertyValue("background-color");
	var color = calculateOpacityColor(opacity);
	var docStyle = document.styleSheets[0];
	var rule = "background: -webkit-gradient(linear, left top, left bottom, from("+bgColor+"), to("+color+"))";
	if(docStyle) {
		docStyle.addRule(targetElement, rule);
	}
}

parent.window.onscroll = updateScrollPosition;

