# `null`'s Bizzare Adventure

A cursed saga of programming languages, null pointers, and the eternal struggle for type safety.

(Written in the style of JoJo's Bizarre Adventure, because the Hoares' curse never ends.)

---

## Part 1 - Phantom Reference

It's the 1960s. The Vietnam War is in full swing, hippies are protesting, everyone's on either cocaine or LSD, and computers are still the size of rooms.

Computers are now the hot new thing, everyone writes in raw machine code or assembly.
A young US seawoman named **Grace Hopper** invents the concept of compilers a couple years earlier. It's revolutionary.
It's the new era of programming. You can write code in some English-like language and turn it into machine code.

High-level languages are born, and with them, ALGOL was created a few years earlier.

Enter Niklaus Wirth and Tony Hoare, two young programmers proposing a standard for a new language called **ALGOL 60**, still currently prototyped
as **ALGOL W**.

Tony needed a way to represent emptiness in this new version of ALGOL (ALGOL W),
so he invented the concept of a **null pointer**.

**The curse begins.**

> "I call it my billion-dollar mistake. It was the invention of the null reference in 1965." – Tony Hoare, 2009

---

## Part 2 - Coercion Tendency

It's now the 90s. Things are weird, people discovers ARPA's Internet, and the World Wide Web is born.

NASA invents the concept of **Defensive Programming** after the Challenger disaster of 1986. They were writing software in pure assembly before then.

The Hoares' curse spreads.

Many languages have null pointers, C/C++ lets you reference null pointers. D&R's invention of the C language @ AT&T and Bjarne Stroustrup's C++ are now the most popular languages in the world.

The curse is now a global phenomenon.

Now people needed a way to handle ISA-agnostic code, and thus, VMs were born.

- Sun Microsystems, the people behind Solaris, invents the **Java Virtual Machine** (JVM) and the Java language... for a smart TV. It claims to run on a billion devices.
- Some random guy named Guido van Rossum invents **Python** in the Netherlands, an interpreted language that's easy to pick up and master, inspired by Monty Python.
- Netscape needed a platform-agnostic way for scripting on web pages so IE wouldn't have a monopoly with VBScript and ActiveX. And specifically, **Brendan Eich** invented **JavaScript** in 10 days for Netscape Navigator 2.0. It later became an ECMA standard. It's not actually Java as many thought.
- Microsoft, not wanting to be left out by Sun's JVM, invents the **Common Language Runtime** (CLR) and the C# language alongside the .NET Framework, a "platform-agnostic" framework... that only runs on Windows (as of then). They also tried to clone the JVM, but no one wanted to use it since the CLR was already there.

**The curse is now a global pandemic. It's gotten worse.**

JavaScript has a null pointer, and so does Java, Python, C#, and many other languages.

Especially JavaScript and sometimes Python, has tendency to coerce types implicitly, leading to many bugs and security issues. Type safety is now a real problem.

> `1 == "1"` is true.
> `[] == 0` is true.
> But `[] + 1` is `"1"`. Why? Nobody knows.
> `null` and `undefined` are separate null types.
> And `NaN` just does whatever it wants.
> All hail `[object Object]`.

---

## Part 3 - Stardust Ownership - The Hoare Curse is Finally Broken

In Mozilla’s lair, a young programmer sees Firefox's C++ codebase and feels horror.

Null pointers, implicit coercions, type safety nightmares.

His name? **Graydon Hoare**, Tony’s distant American "nephew."

Memory safety without garbage collection, Haskell-inspired monads and algebraic data types (especially maybe types like `Option<T>` and `Result<T,E>`),
fearless concurrency, traits, and even a borrow checker to prevent dangling pointers.

It was a revolution in programming languages. It was **Rust**.

The people embrace it. The Hoare name redeemed.

**The Hoares' curse was finally broken...**

**...But like DIO, its legacy lives on.**

> **Iron Chariot** - It's fast, it's safe, and it prevents memory issues, and it's rusting.

---

## Part 4 - Diamond is `any`

Enter 2012. Mayan calendar ended, but Microsoft just started.

Microsoft, after realizing the horrors of JavaScript and its cursed type coercion system, decided to create a new language that would fix all of that.

It was called **TypeScript**.

It transpiles back to JavaScript, but comes with a type system that prevents the horrors of implicit coercion and null pointers.

...The issue is, `any` still exists. The backwards-compatibility blanket type that allows you to put anything inside, defeating the whole point of TypeScript.

Type Safety is still optional, chaos still reigns supreme. Developers still had to deal with broken types and null pointers.

> **Crazy Types** - "Heals" JavaScript, but also lets you merge it back into a mess of `any` types.

---

## Part 5 - The Golden Lizard

Enter 2016.

Watch_Dogs 2 is out. Donald Trump is elected president. People are ironically eating Tide Pods.

Epic Games releases Fortnite, marking the end of the Unreal (Tournament) era.

Andrew Kelley invents **Zig** — explicit, manual memory management, visible `nulls`, comptime macros, and its own C compiler.

It may be carrying the Hoares' cursed legacy, but it's on our side.
No magic, no surprises, just you, an allocator, and your comptime macros — and maybe fewer curses.'

> **Ziggy Stardust** - the explicit lizard Stand. It sees through every line of code, revealing the truth behind the optimizations.

---

## Part 6 - Stone VM

The JVM — a timeless mess.

Enter **Kotlin, Scala, and Clojure**.

They all run on the JVM, but they try to fix the mess that is Java.

They try to bring type safety, null safety, and functional programming to the JVM.

**...Yet the curse persists. Oracle achieves Heaven, and proceeds to reset the whole timeline.**

> **Interface to Heaven** - Java 21 still breaks your code with NPEs, but now Minecraft enforces it.
> And they finally added `Optional<T>` to the standard library, No one uses it.

---

## Part 7 - Steel Ball Types

Typed programming languages are now starting to become the norm.

Google’s **Dart** fails to replace JS but powers Flutter.

Apple’s **Swift** replaces Objective-C — only inside Apple’s kingdom.

TypeScript dominates web dev, but the JS stragglers resist.

**The curse divides the people.**

> **Dirty Code Done Dirt Cheap** - the Stand that makes you write code in a language you hate, but you do it anyway because it’s the reason you still have a job.

---

## Part 8 - JoJoLLM

Enter 2023.

OpenAI launches **GPT-3** and **ChatGPT**; Microsoft integrates it and calls it **Copilot.**

Meta (formerly Facebook) announces **LLaMA**, another competitor to this new wave of AI.
Google does the same thing with **Bard**, eventually renaming it to **Gemini**.

Even Elon Musk himself joins in this new trend by building a startup called **xAI**, building a new LLM called **Grok**. It's now integrated into every fabric of Twitter (now X).

Silicon-based lifeforms wield Stands to write code.

Humans become lazy, outsourcing all their work to the AI. We are complicit in our own downfall.

Code quality immediately nosedives, bugs are everywhere, and the AI doesn't even know or care what it's doing. All it knows is to guess the next token.

**The curse evolves: vibe coding spreads.**

> **I am a Large Language Model** - All it does is write your code for you, but hallucinates and gets it wrong 40% of the time.

---

## Part 9 - SaaSLands

The year is 2025.

"Entrepreneurs" lease Cursor Pro, prompt AI, and churn out useless "B2B" SaaS nobody wants.

VC-funded startups chase exits and golden parachutes, all that matters is the exit strategy and being acquired by a bigger company.

There's no more innovation, no more creativity, just chasing the next big thing, chasing the next big acquisition.

Each startup a Stand, each pitch deck a battle for VC gold.
The true goal: the golden parachute exit.
Because why write good code when you can cash out and ghost?

**When the golden parachute is the only Stand worth having, the bizarre adventure becomes a boardroom snoozefest.**

> **Smooth Agent** - LLM agents now write, debug, run and deploy code for you, but also gives you the worst security vulnerabilities and bugs imaginable.

---

_The curse of null references and bad design never dies — it only evolves, but we still get good stories out of it._

Will the legacy of the Hoares ever end? Will software finally become safe and reliable?

Or will we forever spin in an endless cycle of KPIs, growth hacking, enshittification and busywork?

We may never know. But one thing is for sure.

Software will always be a bizarre adventure.

**_A `null`'s bizarre adventure._**
